/****************************************************************
** bboxprobandlabel.do
** This sub-do file codes for whether the guideline sentence is 
** in a "border box" of the sentencing guideline grid, as well
** as whether there is presumptive probation
***************************************************************/

#delimit;
local count = 1;
while `count' <6 {;

gen bbox`count' = (addnd`count'==1 & ((adlevel`count'==6 & crimhist=="g")|(adlevel`count'==5 & crimhist=="h")|(adlevel`count'==5 & crimhist=="i")))|
            (regime`count' > 1 & addnd`count'==2 & ((adlevel`count'==3 & crimhist == "e")|(adlevel`count'==3 & crimhist == "f")
            |(adlevel`count'==3 & crimhist == "g")|(adlevel`count'==3 & crimhist == "h")|(adlevel`count'== 3 & crimhist == "i")|
            (adlevel`count'== 4 & crimhist == "e")|(adlevel`count'== 4 & crimhist == "f")));

gen prob`count' = (addnd`count'== 1 & ((adlevel`count'== 6 & (crimhist=="h"|crimhist=="i"))|(adlevel`count' > 6 * adlevel`count'<100 & crimhist!= "a" & crimhist!= "b" )))|
            (addnd`count'==2 & adlevel`count'==4 & (crimhist=="g"|crimhist=="h"|crimhist=="i"));


label variable gmin`count' "guideline minimum for count `count'";
label variable gmax`count' "guideline maximum for count `count'";
label variable gpres`count' "guideline presumptive sentence for count `count'";
label variable bbox`count' "border box on sentencing grid for count `count'";
label variable prob`count' "presumptive probation on sentencing grid for count `count'";
local count = `count'+1;
};